import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';

mixin AppActiveContentMixin<T extends StatefulWidget> on State<T> {
  late final AppActiveContent activeContent;

  /// available for override to widgets

  void onLoadEvent() => 'nop';
  void onDisposeEvent() => 'nop';
  bool? onReloadBeforeEvent() => null;
  void onReloadAfterEvent() => 'nop';

  @override
  void initState() {
    activeContent = AppActiveContent(context);
    onLoadEvent();
  }

  @override
  void dispose() {
    activeContent.dispose();
    super.dispose();
  }
}
